import {withBemMod} from '@bem-react/core';

import {cnButton} from '@yandex-lego/components/Button';
import './ButtonViewClearWhite.pcss';

export interface IButtonViewClearWhiteProps {
    /**
     * Вид кнопки для второстепенных действий, используется для обозначения действий не требующих повышенного внимания
     * Применяется в случаях с тёмным фоном
     */
    view?: 'clear-white';
}

/**
 * Модификатор, отвечающий за вид кнопки.
 * @param {IButtonViewClearWhiteProps} props
 */
export const withViewClearWhite = withBemMod<IButtonViewClearWhiteProps>(cnButton(), {view: 'clear-white'});
