import React, {
    ChangeEventHandler,
    FocusEventHandler,
    KeyboardEventHandler,
    MouseEventHandler,
    ReactNode,
    Ref,
} from 'react';
import {Checkbox as CheckboxDesktop} from './Checkbox@desktop';

export interface CheckboxProps {
    lines?: 'multi' | 'one';
    size?: 'm' | 's';
    /**
     * @deprecated use tone/view
     */
    theme?: 'normal' | 'pseudo';
    view?: 'default' | 'outline';
    tone?: 'market' | 'direct'; // Работает в сочетании с  view='default'
    indeterminate?: boolean;

    onBlur?: FocusEventHandler<HTMLElement>;
    onClick?: MouseEventHandler<HTMLElement>;
    onFocus?: FocusEventHandler<HTMLElement>;
    onMouseDown?: MouseEventHandler<HTMLElement>;
    onMouseUp?: MouseEventHandler<HTMLElement>;
    onMouseLeave?: MouseEventHandler<HTMLElement>;
    onMouseEnter?: MouseEventHandler<HTMLElement>;
    focused?: boolean;
    disabled?: boolean;
    pressed?: boolean;
    hovered?: boolean;
    innerRef?: Ref<HTMLElement>;
    label?: ReactNode;
    checked?: boolean;
    tabIndex?: number;

    controlRef?: Ref<HTMLInputElement>;
    className?: string;
    onChange?: ChangeEventHandler<HTMLInputElement>;
    name?: string;
    autoComplete?: string;
    id?: string;
    onKeyUp?: KeyboardEventHandler<HTMLInputElement>;
    onKeyDown?: KeyboardEventHandler<HTMLInputElement>;
}

export class Checkbox extends React.PureComponent<CheckboxProps> {
    public render() {
        return (
            <CheckboxDesktop {...this.props}/>
        );
    }
}
