import {compose, composeU, ExtractProps} from '@bem-react/core';

import {
    Checkbox as CheckboxBase,
    ICheckboxProps as ICheckboxDesktopProps,
    withViewDefault,
    withIndeterminate,
    withLinesMulti,
    withLinesOne,
    withSizeM,
    withSizeS,
    withThemeNormal,
    withThemePseudo,
} from '@yandex-lego/components/Checkbox/desktop';
import {FC} from 'react';
import {withToneMarket} from './tone/CheckboxToneMarket';
import {withToneDirect} from './tone/CheckboxToneDirect';

export interface ICheckboxProps extends ICheckboxDesktopProps {
    lines?: 'multi' | 'one';
    size?: 'm' | 's';
    theme?: 'normal' | 'pseudo';
    view?: 'default' | 'outline';
    indeterminate?: boolean;
}

export const Checkbox = compose(
    withViewDefault,
    withIndeterminate,
    composeU(withLinesMulti, withLinesOne),
    composeU(withSizeM, withSizeS),
    composeU(withThemeNormal, withThemePseudo),
    composeU(withToneMarket, withToneDirect),
)(CheckboxBase) as FC<ICheckboxProps>;

export type CheckboxProps = ExtractProps<typeof Checkbox>;
