import {withBemMod} from '@bem-react/core';
import {cnCheckbox} from '@yandex-lego/components/Checkbox';

import './CheckboxToneDirectTheme.pcss';

export interface ICheckboxToneDirectThemeProps {
    /**
     * Красит фон чекбокса в желтый цвет и делает другой иконку галки
     */
    tone?: 'directTheme';
}

/**
 * Модификатор, отвечающий за цветовое оформление в стиле директа.
 * @param {ICheckboxToneDirectThemeProps} props
 */
export const withToneDirectTheme = withBemMod<ICheckboxToneDirectThemeProps>(cnCheckbox(), {tone: 'directTheme'});
