import {withBemMod} from '@bem-react/core';
import {cnCheckbox} from '@yandex-lego/components/Checkbox';

import './CheckboxToneMarket.pcss';

export interface ICheckboxToneMarketProps {
    /**
     * Красит фон чекбокса в желтый цвет
     */
    tone?: 'market';
}

/**
 * Модификатор, отвечающий за цветовое оформление в стиле маркета.
 * @param {ICheckboxToneMarketProps} props
 */
export const withToneMarket = withBemMod<ICheckboxToneMarketProps>(cnCheckbox(), {tone: 'market'});
