import React from 'react';
import {MouseEventHandler} from 'react';
import {Button} from '../../Button';
import {Icon} from '../../Icon';
import {FilteredSelectProps} from '../FilteredSelect';

import css from './Trigger.pcss';

interface TriggerProps {
    size: FilteredSelectProps['size'];
    opened: boolean;
    onClick: MouseEventHandler;
}

export function Trigger(props: TriggerProps): React.ReactElement {
    const {
        size,
        opened,
        onClick,
    } = props;

    const iconProvider = React.useCallback(() => (classname?: string) => (
        <Icon
            size={size}
            className={classname}
            glyph='type-arrow'
            direction={opened ? 'top' : 'bottom'}
        />
    ), [size, opened]);

    return (
        <Button
            className={css.button}
            size={size}
            onClick={onClick}
            view={'clear'}
            icon={iconProvider()}
            tabIndex={-1}
        />
    );
}
