import {Option} from '../Select';
import {isGroup} from '../Select/withNativeControl';

export function filterOptions(options: Option[], filterByValue: string | undefined): Option[] {
    if (filterByValue === undefined) {
        return [];
    }

    const lowerCaseFilterByValue = filterByValue.toLowerCase();

    return options.map(option => {
        if (isGroup(option)) {
            const items = filterOptions(option.items, lowerCaseFilterByValue);

            if (items.length === 0) {
                return undefined;
            }

            return {
                ...option,
                items,
            };
        }

        const {value, content} = option;

        if (value.toLowerCase() === lowerCaseFilterByValue ||
            typeof content === 'string' && content.toLowerCase().indexOf(lowerCaseFilterByValue) !== -1) {
            return option;
        }

        return undefined;
    }).filter(Boolean) as Option[];
}
