import {Option} from '../Select';
import {isGroup} from '../Select/withNativeControl';

export function getFirstOptionContent(options: Option[]): string | undefined {
    const [firstOption] = options;

    if (!firstOption) {
        return undefined;
    }

    if (isGroup(firstOption)) {
        return getFirstOptionContent(firstOption.items);
    }

    const {content} = firstOption;

    return typeof content === 'string' ? content : undefined;
}
