import React, {
    CSSProperties,
    ReactElement,
} from 'react';

import {Icon as IconDesktop} from './Icon@desktop';

export interface IconProps {
    direction?: 'left' | 'top' | 'right' | 'bottom';
    size?: 'ns' | 'xs' | 's' | 'm' | 'n' | 'l' | 'head';
    style?: CSSProperties;
    url?: string;
    className?: string;
    children?: ReactElement;
    glyph?:
        | 'carets-v'
        | 'type-arrow'
        | 'type-check'
        | 'type-close'
        | 'type-cross-websearch'
        | 'type-cross'
        | 'type-filter'
        | 'type-indeterminate'
        | 'type-tick'
        | 'x-sign'
        | 'type-direct-arrow';
    type?: 'arrow' | 'close' | 'cross' | 'cross-websearch' | 'filter';
}

export class Icon extends React.PureComponent<IconProps> {
    public render() {
        return (
            <IconDesktop {...this.props}/>
        );
    }
}
