import {
    compose,
    composeU,
} from '@bem-react/core';
import {
    Icon as IconBase,
    IIconProps as IIconCommonProps,
    withGlyphCaretsV,
    withGlyphTypeArrow,
    withGlyphTypeCheck,
    withGlyphTypeClose,
    withGlyphTypeCross,
    withGlyphTypeCrossWebsearch,
    withGlyphTypeFilter,
    withGlyphTypeIndeterminate,
    withGlyphTypeTick,
    withGlyphXSign,
    withTypeArrow,
    withTypeClose,
    withTypeCross,
    withTypeCrossWebsearch,
    withTypeFilter,
} from '@yandex-lego/components/Icon';
import {FC} from 'react';
import {withGlyphTypeDirectArrow} from './glyph/IconGlyphDirectArrow';

interface IIconProps extends IIconCommonProps {
    glyph?:
        | 'carets-v'
        | 'type-arrow'
        | 'type-check'
        | 'type-close'
        | 'type-cross-websearch'
        | 'type-cross'
        | 'type-filter'
        | 'type-indeterminate'
        | 'type-tick'
        | 'x-sign'
        | 'type-direct-arrow';
    type?: 'arrow' | 'close' | 'cross' | 'cross-websearch' | 'filter';
}

export const Icon = compose(
    composeU(
        withGlyphCaretsV,
        withGlyphTypeArrow,
        withGlyphTypeCheck,
        withGlyphTypeClose,
        withGlyphTypeCross,
        withGlyphTypeCrossWebsearch,
        withGlyphTypeFilter,
        withGlyphTypeIndeterminate,
        withGlyphTypeTick,
        withGlyphXSign,
        withGlyphTypeDirectArrow,
    ),
    composeU(withTypeArrow, withTypeClose, withTypeCross, withTypeCrossWebsearch, withTypeFilter),
)(IconBase) as FC<IIconProps>;
