import React from 'react';
import {withBemMod} from '@bem-react/core';
import {cnIcon, IIconProps} from '@yandex-lego/components/Icon';

import './IconGlyphDirectArrow.pcss';

export interface IWithGlyphTypeDirectArrowProps {
    /**
     * Символ иконки
     */
    glyph?: 'type-direct-arrow';
}

/**
 * Модификатор, отвечающий за символ иконки.
 * @param {IIconGlyphProps} props
 */
export const withGlyphTypeDirectArrow = withBemMod<IWithGlyphTypeDirectArrowProps, IIconProps>(
    cnIcon(),
    {glyph: 'type-direct-arrow'},
    Icon => ({className, ...props}) => (
        <Icon {...props} className={cnIcon({hasGlyph: true}, [className])}>
            <svg width='16' height='16' viewBox='0 0 16 16' xmlns='http://www.w3.org/2000/svg'>
                <path d='M12.7931 4.79265L8 9.58252L3.20687 4.79265C2.81621 4.40226 2.18304 4.40248 1.79265 4.79313C1.40226 5.18379 1.40248 5.81696 1.79313 6.20735L7.29313 11.7036C7.6836 12.0938 8.3164 12.0938 8.70687 11.7036L14.2069 6.20735C14.5975 5.81696 14.5977 5.18379 14.2073 4.79313C13.817 4.40248 13.1838 4.40226 12.7931 4.79265Z' />
            </svg>
        </Icon>
    ),
);
