import React from 'react';
import {Link as LinkDesktop, LinkProps as LinkPropsDesktop} from './Link@desktop';

export type LinkTheme =
    | 'normal'
    | 'black'
    | 'ghost'
    | 'strong';

export interface LinkProps {
    children?: React.ReactNode;
    className?: string;
    href?: string;
    innerRef?: React.RefObject<HTMLElement>;
    onClick?: LinkPropsDesktop['onClick'];
    pseudo?: boolean;
    tabIndex?: number;
    target?: string;
    /**
     * @deprecated
     */
    theme?: LinkTheme;
    title?: string;
    view?: 'default';
    rel?: string;
}

export class Link extends React.PureComponent<LinkProps> {
    public render() {
        return (
            <LinkDesktop {...this.props}/>
        );
    }
}
