import React, {
    CSSProperties,
    ReactNode,
} from 'react';

import {ChangeEventHandler} from '../types';

import {Menu as MenuDesktop} from './Menu@desktop';

export declare type ItemSimple = {
    value: any;
    content: ReactNode;
    disabled?: boolean;
};
export declare type ItemGroup = {
    title?: string;
    items: ItemSimple[];
};
export declare type MixedItem = ItemSimple | ItemGroup;

export interface MenuProps {
    focused?: boolean;
    items: MixedItem[];
    onChange?: ChangeEventHandler<HTMLElement>;
    value?: any;
    disabled?: boolean;
    innerRef?: React.RefObject<HTMLElement>;
    className?: string;
    style?: CSSProperties;

    size?: 'm' | 's';
    view?: 'default';
    width?: 'auto' | 'max';
}

export class Menu extends React.PureComponent<MenuProps> {
    public render() {
        return (
            <MenuDesktop {...this.props}/>
        );
    }
}
