import React, {
    CSSProperties,
    MouseEventHandler,
    ReactNode,
    Ref,
    RefObject,
} from 'react';
import {Direction} from '../types';
import {toLegoDirection} from '../typeAdapters';

import {Popup as PopupDesktop} from './Popup@desktop';

export declare type OnClose = (event: KeyboardEvent | MouseEvent, source: 'esc' | 'click') => void;

export declare type Position = {
    top: number;
    left: number;
};
export declare type OptionalPosition = {
    top?: number;
    left?: number;
    bottom?: number;
    right?: number;
};
export declare type DrawingParams = {
    direction: Direction | Direction[];
    height: number;
    left: number;
    top: number;
    width: number;
};

export interface PopupTargetAnchorProps {
    anchor?: RefObject<HTMLElement>;
    mainOffset?: number;
    motionless?: boolean;
    secondaryOffset?: number;
    tailOffset?: number;
    target?: 'anchor';
    viewportOffset?: number;
    getPossibleDrawingParams?: (drawingParams: DrawingParams[]) => void;
}

export type PopupProps = PopupTargetAnchorProps & {
    addonAfter?: ReactNode;
    addonBefore?: ReactNode;
    boundary?: RefObject<HTMLElement>;
    direction?: Direction | Direction[];
    hasTail?: boolean;
    innerRef?: Ref<HTMLDivElement>;
    keepMounted?: boolean;
    scope?: RefObject<HTMLElement> | 'inplace'; //  согласно доке LEGO для ренедера попапа без портала
    tailRef?: Ref<HTMLDivElement>;
    tailSize?: number;
    visible?: boolean;
    zIndex?: number;
    className?: string;
    style?: CSSProperties;
    children?: ReactNode | ((props: {
        tailRef?: Ref<HTMLDivElement>;
    }) => ReactNode);
    onClose?: OnClose;
    onClick?: MouseEventHandler<HTMLDivElement>;

    /**
     * @deprecated use `view`
     */
    theme?: 'clear' | 'normal';
    view?: 'default';
    nonvisual?: boolean;
}

export class Popup extends React.PureComponent<PopupProps> {
    public render() {
        const {
            direction,
            ...restProps
        } = this.props;
        const legoDirection = direction && toLegoDirection(direction);
        return (
            <PopupDesktop
                direction={legoDirection}
                {...restProps}
            />
        );
    }
}
