import React, {
    FocusEventHandler,
    KeyboardEventHandler,
    MouseEventHandler,
    ReactNode,
    Ref,
    RefObject,
    SelectHTMLAttributes,
} from 'react';

import {
    ItemSimple,
} from '../Menu';
import {IconProps} from '../Icon';
import {Select as SelectDesktop} from './Select@desktop';
import {
    ChangeEventHandler,
    Pin,
} from '../types';

export declare type RenderOverride<T = any, U = T> = (
    props: T, component: React.ComponentType<U>,
) => React.ReactElement | null;

declare type SelectAllHTMLAttributes = Omit<SelectHTMLAttributes<HTMLSelectElement>, 'size' | 'value'>;

export declare type OptionSimple = ItemSimple & {
    checkedText?: string;
};

export declare type OptionGroup = {
    title?: string;
    items: OptionSimple[];
};

export declare type Option = OptionSimple | OptionGroup;

export interface SelectProps extends SelectAllHTMLAttributes {
    onBlur?: FocusEventHandler<HTMLElement>;
    onClick?: MouseEventHandler<HTMLElement>;
    onKeyDown?: KeyboardEventHandler<HTMLElement>;
    addonAfter?: ReactNode;
    addonBefore?: ReactNode;
    innerRef?: Ref<HTMLElement>;
    options: Option[];
    placeholder?: string;
    size?: string;
    theme?: string;
    triggerRef?: RefObject<HTMLElement>;
    value?: any;
    view?: string;
    showAlwaysPlaceholder?: boolean;
    checkable?: boolean;
    iconProps?: IconProps;
    onChange?: ChangeEventHandler<HTMLSelectElement>;
    opened?: boolean;
    setOpened?: (nextOpened: boolean) => void;
    maxHeight?: number;
    popupRef?: Ref<HTMLDivElement>;
    renderControl?: boolean;
    renderMenu?: RenderOverride;
    renderTrigger?: RenderOverride;
    baseline?: boolean;
    width?: 'max';
    pin?: Pin;
    tone?: 'direct';
    /* eslint-disable-next-line camelcase */
    unsafe_scope?: RefObject<HTMLElement>;
    zIndex?: number;
    disabled?: boolean;
}

export class Select extends React.PureComponent<SelectProps> {
    public render() {
        return (
            <SelectDesktop {...this.props}/>
        );
    }
}
