import {
    compose,
} from '@bem-react/core';
import {
    Registry,
    withRegistry,
} from '@bem-react/di';
import {
    cnSelect,
    Select as SelectDesktop,
    withBaseline,
    withWidthMax,
} from '@yandex-lego/components/Select/desktop';
import {withTogglable} from '@yandex-lego/components/withTogglable';

import {
    Button,
} from '../Button';
import {Icon} from '../Icon';
import {Menu} from '../Menu';
import {
    Popup,
    withTargetAnchor,
    withViewDefault,
} from '@yandex-lego/components/Popup/desktop';
import {withToneDirect} from './tone/SelectToneDirect';

const registry = new Registry({id: cnSelect()})
    .set('Trigger', Button)
    .set('Popup', compose(withTargetAnchor, withViewDefault)(Popup))
    .set('Menu', Menu)
    .set('Icon', Icon);

export const Select = compose(
    withTogglable,
    withBaseline,
    withWidthMax,
    withRegistry(registry),
    withToneDirect,
)(SelectDesktop);
