import React from 'react';
import {compose, withBemMod} from '@bem-react/core';
import {cnSelect} from '@yandex-lego/components/Select/Select';
import {IconProps} from '../../Icon';
import {SelectProps} from '../Select';

import './SelectToneDirect.pcss';

function withDefaultIcon<Props extends SelectProps>(Component: React.ComponentType<Props>): React.ComponentType<Props> {
    const WithIcon: React.FC<Props> = ({iconProps, ...restProps}: Props) => {
        const {
            opened,
            tone,
        } = restProps;

        let newIconProps: IconProps = {
            ...iconProps,
        };

        if (tone === 'direct') {
            newIconProps = {
                glyph: 'type-direct-arrow',
                direction: opened ? 'top' : 'bottom',
                ...iconProps,
            };
        }

        return (
            <Component
                iconProps={newIconProps}
                {...restProps as Props}
            />
        );
    };

    return WithIcon;
}

export interface ISelectToneDirectProps {
    tone?: 'direct';
}

/**
 * Модификатор, отвечающий за цветовое оформление в стиле директа.
 * @param {ISelectToneDirectProps} props
 */
export const withToneDirect = compose(
    withBemMod<ISelectToneDirectProps>(cnSelect(), {tone: 'direct'}),
    withDefaultIcon,
);
