import {FC, ReactNode} from 'react';
import {
    isGroup as legoIsGroup,
    toGroupOptions as legoToGroupOptions,
    withNativeControl as legoWithNativeControl,
} from '@yandex-lego/components/Select/Select.hocs/withNativeControl';
import {Option, OptionGroup, SelectProps} from './Select';

export function isGroup(value: Option): value is OptionGroup {
    return legoIsGroup(value);
}

export function toGroupOptions(option: Option): ReactNode {
    return legoToGroupOptions(option);
}

export function withNativeControl(
    Select: FC<SelectProps>
): ({ addonAfter, name, onChange, options, value, onClick, ...props }: SelectProps) => JSX.Element {
    return legoWithNativeControl(Select);
}
