import React, {RefObject} from 'react';
import {Spin as SpinDesktop} from './Spin@desktop';

export interface SpinProps {
    innerRef?: RefObject<HTMLDivElement>;
    progress?: boolean;
    className?: string;

    size?: 'xxs' | 'xs' | 's' | 'm' | 'l';
    position?: 'center';
    view?: 'default';
}

export class Spin extends React.PureComponent<SpinProps> {
    public render() {
        return (
            <SpinDesktop {...this.props}/>
        );
    }
}
