import React, {CSSProperties, ElementType, ReactNode} from 'react';
import {Text as TextDesktop} from './Text@desktop';

type AlignValue = 'start' | 'end' | 'center' | 'justify';
type OverflowValue = 'fade' | 'ellipsis' | 'fade-horizontal';
type ColorValue = 'brand' | 'inverse' | 'primary' | 'promo' | 'secondary' | 'ghost' | 'control-primary' | 'alert'
    | 'warning' | 'disable' | 'success' | 'control-secondary' | 'control-passive' | 'control-ghost' | 'control-faint'
    | 'control-disable' | 'control-link' | 'control-error' | 'link' | 'link-external' | 'link-minor' | 'link-hover';
export type TypographyValue = 'display-xl' | 'display-l' | 'display-m' | 'display-s' | 'headline-xl' | 'headline-l'
    | 'headline-s' | 'headline-xs' | 'headline-m' | 'subheader-xl' | 'subheader-l' | 'subheader-m' | 'subheader-s'
    | 'body-short-xl' | 'body-short-l' | 'body-short-m' | 'body-short-s' | 'body-long-xl' | 'body-long-l'
    | 'body-long-m' | 'body-long-s' | 'caption-xl' | 'caption-l' | 'caption-m' | 'overline-l' | 'overline-m'
    | 'overline-s' | 'control-xxs' | 'control-xs' | 'control-s' | 'control-l' | 'control-xl' | 'control-m' | 'control-xxl';

type TextWeight = 'light' | 'regular' | 'medium' | 'bold';

export interface TextProps {
    /**
     * Тип элемента для отображения как (строка или компонент).
     */
    as?: ElementType;
    /**
     * Основной контент
     */
    children?: ReactNode;
    /**
     * Дополнительный класс
     */
    className?: string;
    /**
     * Задает выравнивание текста в компоненте.
     */
    align?: AlignValue;
    /**
     * Задает отображение переполненного текста
     */
    overflow?: OverflowValue;
    /**
     * Максимальное количество строк текста (работает в связке с overflow)
     */
    maxLines?: number;
    /**
     * Дополнительные стили
     */
    style?: CSSProperties;
    /**
     * Цвет текста
     */
    color?: ColorValue;
    /**
     * Задает типографику текста в компоненте.
     */
    typography?: TypographyValue;

    /**
     * Насыщенность текста
     */
    weight?: TextWeight;
}

export class Text extends React.PureComponent<TextProps> {
    public render() {
        return (
            <TextDesktop {...this.props} />
        );
    }
}
