import React from 'react';
import {Textinput as TextinputDesktop} from './Textinput@desktop';

export type TextinputSize = 'xxs' | 's' | 'm' | 'l' | 'tool';

export interface TextinputProps {
    onClick?: ((event: React.MouseEvent<HTMLElement, MouseEvent>) => void);
    onMouseDown?: ((event: React.MouseEvent<HTMLElement, MouseEvent>) => void);
    onMouseUp?: ((event: React.MouseEvent<HTMLElement, MouseEvent>) => void);
    focused?: boolean;
    pressed?: boolean ;
    addonAfter?: React.ReactNode;
    addonBefore?: React.ReactNode;
    iconLeft?: React.ReactElement;
    iconRight?: React.ReactElement;
    innerRef?: ((instance: HTMLSpanElement | null) => void) | React.RefObject<HTMLSpanElement> | null;
    style?: React.CSSProperties;
    hint?: string;
    state?: 'error';
    title?: string;
    inputMode?: 'search' | 'text' | 'decimal' | 'numeric' | 'url' | 'email' | 'tel';
    controlRef?: ((instance: HTMLInputElement | null) => void) | React.RefObject<HTMLInputElement> | null;
    autoFocus?: boolean;
    autoComplete?: string;
    name?: string;
    placeholder?: string;
    value?: string | number;
    defaultValue?: string | number;
    type?: string;
    disabled?: boolean;
    id?: string;
    className?: string;
    onChange?: ((event: React.ChangeEvent<HTMLInputElement>) => void);
    onInput?: ((event: React.ChangeEvent<HTMLInputElement>) => void);
    onMouseLeave?: ((event: React.MouseEvent<HTMLInputElement, MouseEvent>) => void);
    onMouseEnter?: ((event: React.MouseEvent<HTMLInputElement, MouseEvent>) => void);
    onBlur?: ((event: React.FocusEvent<HTMLInputElement>) => void);
    onFocus?: ((event: React.FocusEvent<HTMLInputElement>) => void);
    required?: boolean;
    min?: number;
    max?: number;
    pattern?: string;
    tabIndex?: number | string;
    maxLength?: number;
    readOnly?: boolean;
    onKeyUp?: ((event: React.KeyboardEvent<HTMLInputElement>) => void);
    onKeyPress?: ((event: React.KeyboardEvent<HTMLInputElement>) => void);
    onKeyDown?: ((event: React.KeyboardEvent<HTMLInputElement>) => void);
    hovered?: boolean | undefined | any[];
    size?: TextinputSize;
    /**
     * @deprecated
     */
    theme?: 'normal' | 'websearch';
    tone?: 'direct';
    pin?: 'brick-brick'
        | 'brick-clear'
        | 'brick-round'
        | 'clear-brick'
        | 'clear-clear'
        | 'clear-round'
        | 'round-brick'
        | 'round-clear'
        | 'round-round';
    view?: 'default' | 'material';
    baseline?: boolean;
    hasClear?: boolean;
    debounceTimeout?: number;
    role?: string;
}

export class Textinput extends React.PureComponent<TextinputProps> {
    public render() {
        return (
            <TextinputDesktop {...this.props}/>
        );
    }
}
