import {compose, composeU} from '@bem-react/core';

import {
    Textinput as TextinputDesktop,
    withSizeS,
    withSizeM,
    withThemeNormal,
    withThemeWebsearch,
    withPinBrickBrick,
    withPinBrickClear,
    withPinBrickRound,
    withPinClearBrick,
    withPinClearClear,
    withPinClearRound,
    withPinRoundBrick,
    withPinRoundClear,
    withPinRoundRound,
    withViewDefault,
    withViewMaterial,
    withBaseline,
    withHasClear,
} from '@yandex-lego/components/Textinput/desktop';
import {withDebounceInput} from '@yandex-lego/components/withDebounceInput';
import {withSizeTool} from './_size/TextinputSizeTool';
import {withSizeL} from './_size/TextInputSizeL';
import {withSizeXXS} from './_size/TextInputSizeXxs';
import {withToneDirect} from './tone/TextinputToneDirect';

export const Textinput = compose(
    composeU(withSizeM, withSizeS, withSizeTool, withSizeL, withSizeXXS),
    composeU(withThemeNormal, withThemeWebsearch),
    composeU(
        withPinBrickBrick,
        withPinBrickClear,
        withPinBrickRound,
        withPinClearBrick,
        withPinClearClear,
        withPinClearRound,
        withPinRoundBrick,
        withPinRoundClear,
        withPinRoundRound,
    ),
    composeU(
        withViewDefault,
        withViewMaterial,
    ),
    withDebounceInput,
    withBaseline,
    withToneDirect,
    withHasClear,
)(TextinputDesktop);
