import React from 'react';
import {compose, withBemMod} from '@bem-react/core';
import {withRegistry} from '@bem-react/di';
import {cnTextinput} from '@yandex-lego/components/Textinput';

import {toneDirectRegistry} from './TextinputToneDirectClear/registry';
import {Clear} from './TextinputToneDirectClear';

toneDirectRegistry.set('Clear', Clear);

const withDirectRegistry = (Component: React.ComponentType<{}>) => {
    const D = withRegistry(toneDirectRegistry)(Component);

    const RegistrySelector = (props: ITextinputToneDirectProps) => {
        if (props.tone === 'direct') {
            return (
                <D {...props as React.PropsWithChildren<{}>} />
            );
        }

        return (
            <Component {...props as React.PropsWithChildren<{}>} />
        );
    };

    return RegistrySelector;
};

export interface ITextinputToneDirectProps {
    tone?: 'direct';
}

/**
 * Модификатор, отвечающий за цветовое оформление в стиле директа.
 * @param {ITextinputToneDirectProps} props
 */
export const withToneDirect = compose(
    withBemMod<ITextinputToneDirectProps>(cnTextinput(), {tone: 'direct'}),
    withDirectRegistry,
);
