import {Direction} from './types';
import {Direction as LegoDirection} from '@yandex-lego/components/Popup';

const MAP: Record<Direction, LegoDirection> = {
    'bottom-left': 'bottom-start',
    'bottom-center': 'bottom',
    'bottom-right': 'bottom-end',
    'top-left': 'top-start',
    'top-center': 'top',
    'top-right': 'top-end',
    'right-top': 'right-start',
    'right-center': 'right',
    'right-bottom': 'right-end',
    'left-top': 'left-start',
    'left-center': 'left',
    'left-bottom': 'left-end',
};

export function toLegoDirection(dir: Direction | Direction[]): LegoDirection[] {
    return (Array.isArray(dir) ? dir : [dir]).map(
        (d: Direction): LegoDirection => MAP[d] || d,
    );
}
