import React from 'react';

export type KeyboardKeys = 'BACKSPACE' | 'TAB' | 'ENTER' | 'CAPS_LOCK' | 'ESC' | 'SPACE' | 'PAGE_UP' | 'PAGE_DOWN' | 'END' | 'HOME' | 'LEFT' | 'UP' | 'RIGHT' | 'DOWN' | 'INSERT' | 'DELETE' | number;

export declare type ChangeEvent<T> = React.ChangeEvent<T & {
    name?: string;
    value: any;
}>;

export declare type ChangeEventHandler<T> = (event: ChangeEvent<T>) => void;

export declare type Direction =
    | 'bottom-left'
    | 'bottom-center'
    | 'bottom-right'
    | 'top-left'
    | 'top-center'
    | 'top-right'
    | 'right-top'
    | 'right-center'
    | 'right-bottom'
    | 'left-top'
    | 'left-center'
    | 'left-bottom';

export type Pin =
    | 'brick-brick'
    | 'brick-circle'
    | 'brick-clear'
    | 'brick-round'
    | 'circle-brick'
    | 'circle-circle'
    | 'circle-clear'
    | 'clear-brick'
    | 'clear-circle'
    | 'clear-clear'
    | 'clear-round'
    | 'round-brick'
    | 'round-clear';
