import {connect} from 'react-redux';
import {Dispatch} from 'redux';
import { Action } from 'redux-actions';
import {changeLocale} from '../../actions';
import {ApplicationStateT} from '../../types/state';
import {DesktopHead} from '../components/Head/DesktopHead/DesktopHead';
import {DesktopHeadDispatchProps, DesktopHeadStateProps} from '../components/Head/DesktopHead/types';
import {langSelector} from '../selectors/simpleFormSelectors';

function mapStateToProps(state: ApplicationStateT): DesktopHeadStateProps {
    const user = state.remote.user;

    const {
        userId,
        displayLogin,
    } = user || {};

    return {
        displayLogin,
        userId,
        locale: langSelector(state),
    };
}

function mapDispatchToProps(dispatch: Dispatch<Action<any>>): DesktopHeadDispatchProps {
    return {
        onChangeLang: lang => dispatch(changeLocale(lang)),
    };
}

export const HeadContainer = connect(mapStateToProps, mapDispatchToProps)(DesktopHead);
