import {connect} from 'react-redux';
import {Dispatch} from 'redux';
import {Action} from 'redux-actions';
import {ApplicationStateT} from '../../types/state';
import {fieldValueChange, submit} from '../actions/SimpleFormActions';
import {SimpleFormPage, SimpleFormPageDispatchProps, SimpleFormPageStateProps} from '../components/SimpleFormPage';
import {
    allFieldsAreValidSelector,
    fieldsDataSelector,
    isPendingSelector,
    langSelector,
} from '../selectors/simpleFormSelectors';

function mapStateToProps(state: ApplicationStateT): SimpleFormPageStateProps {
    return {
        isPending: isPendingSelector(state),
        fieldsData: fieldsDataSelector(state),
        submitButtonEnabled: allFieldsAreValidSelector(state),
        lang: langSelector(state),
    };
}

function mapDispatchToProps(dispatch: Dispatch<Action<any>>): SimpleFormPageDispatchProps {
    return {
        onSubmit: () => dispatch(submit()),
        onFieldValueChange: (name, value) => dispatch(fieldValueChange({name, value})),
    };
}

export const SimpleFormPageContainer = connect(mapStateToProps, mapDispatchToProps)(SimpleFormPage);
