// https://stackoverflow.com/a/41429145/4482107

export class BaseError extends Error {
    constructor(m: string, public readonly name = 'BaseError') {
        super(m);

        // Производные классы будут иметь прототип этого класса,
        // так их можно будет отличить от системных, а различать между собой - по `name`.
        // Таким образом не нужно будет в каждом классе переустанавливать прототип.
        // Этот подход был использован в унаследованном коде.
        Object.setPrototypeOf(this, BaseError.prototype);
    }
}
