import {Option} from '../components/uikit/Select';

export const enum FieldType {
    Input = 'input',
    Boolean = 'boolean',
    Date = 'date',
    Oferta = 'oferta',
    Select = 'select',
    FilteredSelect = 'filteredSelect',
    MultiSelect = 'multiSelect',
    Radio = 'radio',
    Text = 'text',
}

export interface DictionaryValue {
    content: string;
    value: FieldValue;
}

export interface BaseFieldConfig {
    label: string;
    name: string;
    required: boolean;
    error?: string;
    hint?: string;
    style?: string;
}

export interface InputFieldConfig extends BaseFieldConfig {
    type: FieldType.Input;
    value?: string;
}

export interface CheckboxFieldConfig extends BaseFieldConfig {
    type: FieldType.Boolean;
    value?: boolean;
}

export interface DateFieldConfig extends BaseFieldConfig {
    type: FieldType.Date;
    value?: string;
}

export interface OfertaFieldConfig extends Omit<CheckboxFieldConfig, 'type'> {
    type: FieldType.Oferta;
    url?: string;
}

export interface SelectFieldConfig extends BaseFieldConfig {
    type: FieldType.Select;
    values: DictionaryValue[];
    value?: string;
}

export interface FilteredSelectFieldConfig extends BaseFieldConfig {
    type: FieldType.FilteredSelect;
    values: Option[];
    value?: string;
}

export interface MultiselectFieldConfig extends BaseFieldConfig {
    type: FieldType.MultiSelect;
    values: DictionaryValue[];
    value?: string[];
}

export interface RadioFieldConfig extends BaseFieldConfig {
    type: FieldType.Radio;
    values: DictionaryValue[];
    value?: string;
}

export interface TextFieldConfig extends BaseFieldConfig {
    type: FieldType.Text;
    value?: null;
}

export type FieldData =
    | InputFieldConfig
    | OfertaFieldConfig
    | CheckboxFieldConfig
    | SelectFieldConfig
    | FilteredSelectFieldConfig
    | MultiselectFieldConfig
    | RadioFieldConfig
    | DateFieldConfig
    | TextFieldConfig;

export type FieldValue = any; // FieldData['value'];

export interface FieldsData {
    fields: FieldData[];
}
