import React, {ReactElement} from 'react';
import ReactHtmlParser, {convertNodeToElement} from 'react-html-parser';
import {Link} from '../components/uikit/Link';

type ParserNode = {
    children: ParserNode[],
    attribs: {
        href: string,
        target: string,
    },
    data: string,
    name: string,
    next: ParserNode,
    parent: ParserNode,
    prev: ParserNode,
    type: string,
};

function _transform(node: ParserNode, index: number): ReactElement | void | null {
    const {name, type, attribs} = node;

    if (name !== 'a' || type !== 'tag') {
        return;
    }

    const content = node.children.map(node => convertNodeToElement(node, index, _transform));

    return (
        <Link href={attribs.href} target={attribs.target} key={attribs.href}>
            {content}
        </Link>
    );
}

export function htmlToReact(html: string) {
    return ReactHtmlParser(html, {transform: _transform});
}
