export type SchemaT = {
    enum?: Array<boolean | string | number>,
    minLength?: number,
    maxLength?: number,
    minItems?: number,
    items?: {
        enum?: unknown[];
        type?: string;
    },
    negativePattern?: string | Array<string>,
    pattern?: string,
    format?: string,
    type: string,
};

type DictionaryItem = {
    description: string,
    value: string,
}

export type BaseFieldDefT = {
    groupName: string,
    name?: string,
    id: string,
    jsonSchema: SchemaT,
    value?: any,
    hint?: string,
    dependencies?: {[key: string]: any},
    dictionary?: DictionaryItem[],
    style?: string,
};

export type BooleanFieldDefT = BaseFieldDefT & {
    type: 'boolean' | 'boolean_true' | 'oferta_agreement',
};

export type CampaignCreationFieldDefT = BaseFieldDefT & {
    type: 'campaign_creation',
};

export type IbanOrAccountFieldDefT = BaseFieldDefT & {
    type: 'iban_or_account',
};

export type InputFieldDefT = BaseFieldDefT & {
    type: 'input' | 'date' | 'date_18' | 'textarea',
};

export type SelectFieldDefT = BaseFieldDefT & {
    type: 'currency',
    options: Array<{label: string, value: string}>,
};

export type MultiSelectFieldDefT = BaseFieldDefT & {
    type: 'multiselect',
    options: Array<{label: string, value: string}>,
};

export type TextFieldDefT = BaseFieldDefT & {
    type: 'gfm_text',
};

export type RadioFieldDefT = BaseFieldDefT & {
    type: 'radio',
};

export type FieldDefT =
    BooleanFieldDefT |
    CampaignCreationFieldDefT |
    IbanOrAccountFieldDefT |
    InputFieldDefT |
    SelectFieldDefT |
    TextFieldDefT |
    RadioFieldDefT |
    MultiSelectFieldDefT;

export const WRONG_ADFOX_CREDENTIALS_ERROR_TOKEN = 'adfox_api_access_1';
export const HAS_ADFOX_PAID_SERVICES_ERROR_TOKEN = 'adfox_has_paid';
