import {SimpleFormState} from '../simple/reducers/SimpleFormReducer';
import {FieldDefT} from './fields';

export type CAN_FILL_FORM_REASON =
    | 'need_postregistration'
    | 'technical_account'
    | 'registered'
    | 'representative';

export type UserDataT = {
    canFillForm: boolean | null,
    canFillFormMessage?: string,
    canFillFormReason?: CAN_FILL_FORM_REASON,
    canonicalLogin: string | null,
    displayLogin: string | null,
    force?: {
        branchId: string,
        countryId: string,
    },
    hasRoleInPartner2: boolean | null,
    isLogged: boolean,
    language: string | null,
    userId: string | null,
    version?: number,
};

export type CountryDataT = {
    branches: {
        [branchId: string]: {
            branchName: string,
            oferta: boolean,
            ofertaId: string,
            ofertaUrl: string,
        },
    },
    countryName: string,
    order: Array<string>,
};

export type TreeDataT = {
    [countryCode: string]: CountryDataT,
};

export type BranchDataT = {
    fields: Array<FieldDefT>,
};

export type OfferDataT = {
    html: string,
};

export type FiasT = {
    formalName: string,
    guid: string,
    objLevel: string,
    shortName: string,
};

export type FiasDataT = {[guid: string]: Array<FiasT>};

export type StoreFieldErrorT = string | Array<StoreFieldErrorT> | Record<string, string> | null;
export type StoreFieldHintT = string | Record<string, string> | null;

export type StoreFieldT = {
    $$error: StoreFieldErrorT,
    $$focus: boolean,
    $$hint: StoreFieldHintT,
    $$pending: boolean,
    $$touched: boolean,
    $$visible: boolean,
    $$value: any,
};

export type StoreT = {
    [fieldId: string]: StoreFieldT,
};

export type ErrorWithIdT = {id: string, error: Error};

export type FieldGroupT = {name: string, fields: Array<string>};

export type ApplicationStateT = {
    local: {
        branchId?: string | null,
        countryId?: string,
        scrollTo?: string | null,
        serializedFields?: {[fieldId: string]: unknown},
        errorStack?: Array<ErrorWithIdT>,
        fieldGroups?: Array<FieldGroupT> | null,
        pending?: number,
    },
    remote: {
        branch?: BranchDataT | null,
        fias?: FiasDataT,
        tree?: TreeDataT,
        user?: UserDataT,
        offer?: OfferDataT,
        headings?: Array<string>,
    },
    router: {
        location?: {
            pathname: string,
            search: string,
            hash: string,
            key: string,
        },
    },
    store: StoreT,
    simpleForm: SimpleFormState,
};

export type FileDescT = {
    id: string,
    file: File,
    pending: boolean,
    ok: boolean,
    key: string,
}

// Address store field
export type AddressT = {
    apartment: string | null,
    building: string | null,
    guid: string,
    house: string,
    levels: {[level: string]: string},
    office: string | null,
    structure: string | null,
    zipCode: string,
}

export type MobileAppCreationEntryT = {
    bundleId: string,
    platform: string,
    storeLink: string,
};

export type MobileAppCreationT = Array<MobileAppCreationEntryT>;

// YandexMoneyDetails store field

export type YandexMoneyDetailsFieldsT = {
    firstName: string,
    lastName: string,
    passportNumber: string,
    patronymicName: string,
    yandexMoney: string,
}

export type YandexMoneyDetailsModeT = 'yandexMoney';

export type YandexMoneyDetailsT = {
    mode: YandexMoneyDetailsModeT,
    fields: YandexMoneyDetailsFieldsT,
};

// BikWithAccountOrYandexMoney store field
export type BikWithAccountOrYandexMoneyBankFieldsT = {
    bik: string,
    account: string,
}

export type BikWithAccountOrYandexMoneyYandexMoneyFieldsT = {
    yandexMoney: string,
}

export type BikWithAccountOrYandexMoneyModeT = 'bank' | 'yandexMoney';

export type BikWithAccountOrYandexMoneyT = {
    mode: BikWithAccountOrYandexMoneyModeT,
    fields: BikWithAccountOrYandexMoneyBankFieldsT | BikWithAccountOrYandexMoneyYandexMoneyFieldsT,
};

export type AdfoxAccountT = {
    adfoxOffer?: boolean,
    hasAccount: boolean,
    hasAdfoxPaid: boolean,
    login: string,
    password: string,
};
