// @flow
'use strict';

import * as React from 'react';

import {withDefaultProps} from '../../src/lib/components';

class TestComponent extends React.Component<*> {}

describe('withDefaultProps()', () => {
    it('returns wrapped component with default props', () => {
        const WrappedComponent = withDefaultProps(TestComponent, {propA: 'A', propB: 'B'});
        const instance = new WrappedComponent({propA: 'AA', propC: 'C'});
        const {props} = instance.render();

        expect(props).toEqual({propA: 'AA', propB: 'B', propC: 'C'});
    });
});
