// @flow
'use strict';

import {
    addStrings,
    translate,
} from '../../src/lib/i18n';

import i18next from 'i18next';

// 'validators', 'Field should contain at least {minLength} characters', {minLength: 9}

describe('translate()', () => {
    beforeAll(() => {
        addStrings({
            en: {
                keysetOne: {
                    keyOne: 'First key',
                    keyTwo: 'Second key with argument: {arg}',
                },
                keysetTwo: {
                    keyOne: [
                        'I\'ve seen {count} helicopter',
                        'I\'ve seen {count} helicopters',
                    ],
                },
            },
            ru: {
                keysetOne: {
                    keyOne: 'Первый ключ',
                    keyTwo: 'Второй ключ с аргументом: {arg}',
                },
                keysetTwo: {
                    keyOne: [
                        'Я видел {count} вертолет',
                        'Я видел {count} вертолета',
                        'Я видел {count} вертолетов',
                    ],
                },
            },
        });
    });

    it('translates a string', () => {
        expect(translate('keysetOne', 'keyOne')).toBe('Первый ключ');
    });

    it('translates a string with argument', () => {
        expect(translate('keysetOne', 'keyTwo', {arg: 'ABC'})).toBe('Второй ключ с аргументом: ABC');
    });

    it('translates a string with plural argument', () => {
        expect(translate('keysetTwo', 'keyOne', {count: 1})).toBe('Я видел 1 вертолет');
        expect(translate('keysetTwo', 'keyOne', {count: 2})).toBe('Я видел 2 вертолета');
        expect(translate('keysetTwo', 'keyOne', {count: 5})).toBe('Я видел 5 вертолетов');
    });

    it('translates a string with plural argument in english', done => {
        i18next.changeLanguage('en', () => {
            expect(translate('keysetTwo', 'keyOne', {count: 1})).toBe('I\'ve seen 1 helicopter');
            expect(translate('keysetTwo', 'keyOne', {count: 2})).toBe('I\'ve seen 2 helicopters');
            done();
        });
    });
});
