// @flow
'use strict';

import {
    getLocation,
    getReload,
} from '../../src/lib/location';

describe('getLocation()', () => {
    it('returns current location', () => {
        const location = getLocation();
        expect(location.href).toBe('http://localhost/');
    });
});

describe('getReload()', () => {
    const realReload = window.location.reload;

    beforeAll(() => {
        // https://github.com/facebook/jest/issues/9471#issuecomment-614736705
        Object.defineProperty(window, 'location', {
            value: {
                reload: jest.fn(),
            },
        });
    });

    afterAll(() => {
        Object.defineProperty(window, 'location', {
            value: {
                realReload,
            },
        });
    });

    it('returns reload function', () => {
        const reload = getReload();

        reload();

        expect(window.location.reload.mock.calls.length).toEqual(1);
    });
});
