// @flow
'use strict';

const {assign} = Object;

import {
    composeReducers,
    composeWithScopedReducers,
} from '../../src/lib/reducers';

describe('composeReducers()', () => {
    it('returns reducers director which dispatches actions', () => {
        const reducers = {
            TEST_ONE_ACTION: (state, action) => assign({}, state, {testOne: action.payload}),
            TEST_TWO_ACTION: (state, action) => assign({}, state, {testTwo: action.payload}),
        };

        const composedReducers = composeReducers(reducers);
        const state = {testOne: null, testTwo: null};

        // $FlowFixMe
        const stepOneState = composedReducers(state, {type: 'TEST_ONE_ACTION', payload: 123});
        expect(stepOneState).toEqual({
            testOne: 123,
            testTwo: null,
        });

        const stepTwoState = composedReducers(stepOneState, {type: 'TEST_TWO_ACTION', payload: 'ABC'});
        expect(stepTwoState).toEqual({
            testOne: 123,
            testTwo: 'ABC',
        });
    });
});

describe('composeWithScopedReducers()', () => {
    it('returns scoped reducers director which dispatches actions', () => {
        const baseReducer = (state, action) =>
            action.type === 'TEST_ONE_ACTION'
                ? assign({}, state, {testOne: action.payload})
                : state;
        const scopedReducer = (state, action) =>
            action.type === 'TEST_TWO_ACTION'
                ? assign({}, state, {testTwo: action.payload})
                : state;

        const composedReducers = composeWithScopedReducers(baseReducer, {testScope: scopedReducer});
        const state = {testOne: null, testScope: {testTwo: null}};

        // $FlowFixMe
        const stepOneState = composedReducers(state, {type: 'TEST_ONE_ACTION', payload: 'ABC'});
        expect(stepOneState).toEqual({
            testOne: 'ABC',
            testScope: {
                testTwo: null,
            },
        });

        const stepTwoState = composedReducers(stepOneState, {type: 'TEST_TWO_ACTION', payload: 'DEF'});
        expect(stepTwoState).toEqual({
            testOne: 'ABC',
            testScope: {
                testTwo: 'DEF',
            },
        });
    });
});
