import {serializers} from '../../src/lib/serializers';

describe('serializers', () => {
    describe('input serializer', () => {
        const {input} = serializers;

        test('input serializer - string value', () => {
            const value = 'Test String';
            const serializedValue = input(value);

            expect(serializedValue).toEqual('Test String');
        });

        test('input serializer - string value with spaces', () => {
            const value = ' Test String     ';
            const serializedValue = input(value);

            expect(serializedValue).toEqual('Test String');
        });

        test('input serializer - not string value', () => {
            const value = undefined;
            const serializedValue = input(value);

            expect(serializedValue).toEqual(null);
        });
    });
});
