// @flow
'use strict';

import {
    camelizeObjectKeys,
    decamelizeObjectKeys,
    getUniqId,
} from '../../src/lib/utils';

describe('camelizeObjectKeys()', () => {
    describe('with deep === false', () => {
        it('returns shallowly camelized object', () => {
            const payload = {
                attribute_one: {
                    attribute_one_one: [],
                    attribute_one_two: 2,
                },
                attribute_two: [],
            };

            expect(camelizeObjectKeys(payload)).toEqual({
                attributeOne: {
                    attribute_one_one: [],
                    attribute_one_two: 2,
                },
                attributeTwo: [],
            });
        });
    });

    describe('with deep === true', () => {
        it('returns deeply camelized object', () => {
            const payload = {
                attribute_one: {
                    attribute_one_one: [],
                    attribute_one_two: 2,
                },
                attribute_two: [],
            };

            expect(camelizeObjectKeys(payload, true)).toEqual({
                attributeOne: {
                    attributeOneOne: [],
                    attributeOneTwo: 2,
                },
                attributeTwo: [],
            });
        });
    });
});

describe('decamelizeObjectKeys()', () => {
    describe('with deep === false', () => {
        it('returns shallowly decamelized object', () => {
            const payload = {
                attributeOne: {
                    attributeOneOne: [],
                    attributeOneTwo: 2,
                },
                attributeTwo: [],
            };

            expect(decamelizeObjectKeys(payload)).toEqual({
                attribute_one: {
                    attributeOneOne: [],
                    attributeOneTwo: 2,
                },
                attribute_two: [],
            });
        });
    });

    describe('with deep === true', () => {
        it('returns deeply decamelized object', () => {
            const payload = {
                attributeOne: {
                    attributeOneOne: [],
                    attributeOneTwo: 2,
                },
                attributeTwo: [],
            };

            expect(decamelizeObjectKeys(payload, true)).toEqual({
                attribute_one: {
                    attribute_one_one: [],
                    attribute_one_two: 2,
                },
                attribute_two: [],
            });
        });
    });
});

describe('getUniqId()', () => {
    it('returns first unique id', () => {
        expect(getUniqId()).toBe('00000001');
    });
    it('returns second unique id', () => {
        expect(getUniqId()).toBe('00000002');
    });
    it('returns third unique id', () => {
        expect(getUniqId()).toBe('00000003');
    });
    it('returns fourth unique id', () => {
        expect(getUniqId()).toBe('00000004');
    });
});
