// @flow
'use strict';

import {
    PUSH_ERROR_ACTION,
    REMOVE_ERROR_ACTION,
} from '../../src/actions';

import {composeReducers} from '../../src/lib/reducers';

import {errorsReducer} from '../../src/reducers/errorsReducer';

const testErrorsReducer = composeReducers(errorsReducer);

describe('errorsReducer', () => {
    it('on action PUSH_ERROR_ACTION', () => {
        const action = {
            type: PUSH_ERROR_ACTION,
            payload: {
                error: new Error(),
            },
        };

        const state = {
            local: {
                errorStack: [],
            },
            remote: {},
            store: {},
            router: {},
            simpleForm: {},
        };

        const nextState = testErrorsReducer(state, action);

        expect(nextState.local).toEqual({
            errorStack: [{
                error: new Error(),
                id: '_teatime1',
            }],
        });
    });

    it('on action REMOVE_ERROR_ACTION', () => {
        const action = {
            type: REMOVE_ERROR_ACTION,
            payload: {
                id: '_teatime1',
            },
        };

        const state = {
            local: {
                errorStack: [
                    {
                        error: new Error(),
                        id: '_teatime1',
                    },
                    {
                        error: new Error(),
                        id: '_teatime2',
                    },
                ],
            },
            remote: {},
            store: {},
            router: {},
            simpleForm: {},
        };

        const nextState = testErrorsReducer(state, action);

        expect(nextState.local).toEqual({
            errorStack: [{
                error: new Error(),
                id: '_teatime2',
            }],
        });
    });
});
