// @flow
'use strict';

import {
    LOCK_PENDING_ACTION,
    UNLOCK_PENDING_ACTION,
    RECEIVE_FIAS_ACTION,
} from '../../src/actions';

import {composeReducers} from '../../src/lib/reducers';

import {miscReducer} from '../../src/reducers/miscReducer';

const testMiscReducer = composeReducers(miscReducer);

describe('miscReducer', () => {
    it('on action LOCK_PENDING_ACTION', () => {
        const action = {
            type: LOCK_PENDING_ACTION,
            payload: null,
        };

        const state = {
            local: {},
            remote: {},
            router: {},
            store: {},
            simpleForm: {},
        };

        const nextState = testMiscReducer(state, action);

        expect(nextState).toEqual({
            local: {
                pending: 1,
            },
            remote: {},
            router: {},
            store: {},
            simpleForm: {},
        });
    });

    it('on action UNLOCK_PENDING_ACTION', () => {
        const action = {
            type: UNLOCK_PENDING_ACTION,
            payload: null,
        };

        const state = {
            local: {
                pending: 2,
            },
            remote: {},
            router: {},
            store: {},
            simpleForm: {},
        };

        const nextState = testMiscReducer(state, action);

        expect(nextState).toEqual({
            local: {
                pending: 1,
            },
            remote: {},
            router: {},
            store: {},
            simpleForm: {},
        });
    });

    it('on action RECEIVE_FIAS_ACTION', () => {
        const action = {
            type: RECEIVE_FIAS_ACTION,
            payload: {
                guid: 'ROOT',
                data: [{
                    formal_name: 'Алтай',
                }],
            },
        };

        const state = {
            remote: {},
            router: {},
            store: {},
            local: {},
            simpleForm: {},
        };

        const nextState = testMiscReducer(state, action);

        expect(nextState).toEqual({
            remote: {
                fias: {
                    ROOT: [{
                        formalName: 'Алтай',
                    }],
                },
            },
            router: {},
            store: {},
            local: {},
            simpleForm: {},
        });
    });
});
