// @flow
'use strict';

import {
    selectBranchUrl,
    selectCurrentUserUrl,
    selectSubmitFormUrl,
    selectSubmitOfferUrl,
    selectTreeUrl,
    selectValidationUrl,
    selectOfferUrl,
    selectUploadFileUrl,
    selectFiasQueryUrl,
    selectOfferPageUrl,
    selectDashboardUrl,
    selectRestApiSiteUrl,
    selectRestApiMobileAppUrl,
    selectRestApiContextCampaignUrl,
    selectRestApiMobileAppSettingsUrl,
} from '../../src/selectors/url';

describe('selectBranchUrl()', () => {
    it('simple function start', () => {
        const state = {
            remote: {},
            store: {},
            local: {},
            router: {},
            simpleForm: {},
        };

        const branchId = 'russia_ur';

        expect(selectBranchUrl(state, branchId)).toBe('/form/api/0/branch?id=russia_ur');
    });
});

describe('selectCurrentUserUrl()', () => {
    it('simple function start', () => {
        expect(selectCurrentUserUrl()).toBe('/form/api/0/current_user');
    });
});

describe('selectSubmitFormUrl()', () => {
    it('simple function start', () => {
        expect(selectSubmitFormUrl()).toBe('/form/api/0/submit');
    });
});

describe('selectSubmitOfferUrl()', () => {
    it('simple function start', () => {
        const state = {
            remote: {},
            store: {},
            local: {},
            router: {},
            simpleForm: {},
        };

        const id = 'test_id';

        expect(selectSubmitOfferUrl(state, id)).toBe('/form/api/0/submit_oferta?id=test_id');
    });
});

describe('selectTreeUrl()', () => {
    it('simple function start', () => {
        expect(selectTreeUrl()).toBe('/form/api/0/dispatcher');
    });
});

describe('selectValidationUrl()', () => {
    it('if oll values is valid', () => {
        const state = {
            remote: {},
            store: {},
            local: {},
            router: {},
            simpleForm: {},
        };

        const id = 'test_id';
        const value = 'test_value';

        expect(selectValidationUrl(state, id, value)).toBe('/form/api/0/test_id?value=test_value');
    });
});

describe('selectOfferUrl()', () => {
    it('if oll values is valid', () => {
        const state = {
            remote: {},
            store: {},
            local: {},
            router: {},
            simpleForm: {},
        };

        const id = 'test_id';
        const language = 'ru';

        expect(selectOfferUrl(state, id, language)).toBe('/form/api/0/oferta?id=test_id&language=ru');
    });
});

describe('selectUploadFileUrl()', () => {
    it('simple function start', () => {
        expect(selectUploadFileUrl()).toBe('/form/api/0/save_attachment');
    });
});

describe('selectFiasQueryUrl()', () => {
    it('returns value `/form/api/0/query_fias?parent_guid=test_guid` when value `guid` is `test_guid`', () => {
        const state = {
            remote: {},
            store: {},
            local: {},
            router: {},
            simpleForm: {},
        };

        const guid = 'test_guid';

        expect(selectFiasQueryUrl(state, guid)).toBe('/form/api/0/query_fias?parent_guid=test_guid');
    });

    it('returns value `/form/api/0/query_fias` when value `guid` is null', () => {
        const state = {
            remote: {},
            store: {},
            local: {},
            router: {},
            simpleForm: {},
        };

        const guid = null;

        expect(selectFiasQueryUrl(state, guid)).toBe('/form/api/0/query_fias');
    });
});

describe('selectOfferPageUrl()', () => {
    it('simple function start', () => {
        expect(selectOfferPageUrl()).toBe('/form/offer');
    });
});

describe('selectDashboardUrl()', () => {
    it('simple function start', () => {
        expect(selectDashboardUrl()).toBe('/v2/dashboard/');
    });
});

describe('selectRestApiSiteUrl()', () => {
    it('simple function start', () => {
        expect(selectRestApiSiteUrl()).toBe('/restapi/v1/site');
    });
});

describe('selectRestApiMobileAppUrl()', () => {
    it('simple function start', () => {
        expect(selectRestApiMobileAppUrl()).toBe('/restapi/v1/mobile_app');
    });
});

describe('selectRestApiContextCampaignUrl()', () => {
    it('simple function start', () => {
        expect(selectRestApiContextCampaignUrl()).toBe('/restapi/v1/context_on_site_campaign');
    });
});

describe('selectRestApiMobileAppSettingsUrl()', () => {
    it('simple function start', () => {
        expect(selectRestApiMobileAppSettingsUrl()).toBe('/restapi/v1/mobile_app_settings');
    });
});
