#!/bin/bash

# Linux не поддерживает host.docker.internal (https://github.com/docker/for-linux/issues/264)
# Поэтому добавляем его руками (https://dev.to/bufferings/access-host-from-a-docker-container-4099)

HOST_DOMAIN="host.docker.internal"
ping -q -c1 $HOST_DOMAIN > /dev/null 2>&1
if [ $? -ne 0 ]; then
  HOST_IP=$(ip route | awk 'NR==1 {print $3}')
  echo -e "$HOST_IP\t$HOST_DOMAIN" >> /etc/hosts
fi

/usr/sbin/nginx -c /etc/nginx/nginx.conf -g "daemon off;"
