'use strict';

const {defaults, result} = require('lodash');

const config = defaults(require('../package').config || {}, {
  githubToken: 'KRUSH_GITHUB_OAUTH',
  sandboxToken: 'KRUSH_SANDBOX_OAUTH',
  startrackToken: 'KRUSH_STARTRACK_OAUTH',
  repo: {},
  servant: null,
  estimation: {},
  teams: {},
  workers: 1,
  resolve_tickets_for_users: [],
});

const cfg = {
  githubToken: result(process.env, config.githubToken),
  sandboxToken: result(process.env, config.sandboxToken),
  startrackToken: result(process.env, config.startrackToken),
  port: process.env.QLOUD_HTTP_PORT || process.env.PORT || config.port || 80,
  repo: config.repo,
  estimation: config.estimation,
  servant: config.servant,
  teams: config.teams,
  vacation: config.vacation,
  workers: config.workers,
  resolve_tickets_for_users: config.resolve_tickets_for_users,
};

module.exports = cfg;
