'use strict';

const recluster = require('recluster');
const path = require('path');

const cfg = require('./config');
const workers = process.env.WORKERS || cfg.workers;

// Starting workers for stories
const workerPath = path.join(__dirname, 'worker.js');
const cluster = recluster(workerPath, {workers: workers});
cluster.run();

// Registering cronjobs
const {CronJob} = require('cron');
const {sync: glob} = require('glob');

const cronJobsPath = path.join(__dirname, 'crons');

const cronJobs = glob(`${cronJobsPath}/*.js`);

for (let cronJobFilename of cronJobs) {
    const cronJob = require(cronJobFilename);
    const job = new CronJob(cronJob);
    job.start();
}
