'use strict';

const events = {
  issueComment: require('./issueComment'),
  pullRequest: require('./pullRequest'),
  status: require('./status'),
};

/***
 * @param  {string} event
 * @param  {object} [scenarios]
 * @return {Boolean}
 */
function hasHook(event, scenarios) {
  return typeof (scenarios || events)[event] === 'function';
}

/**
 * @param  {string}    event
 * @param  {object}    body
 * @param  {github}    gh
 * @param  {startrack} st
 * @param  {object}    [scenarios]
 * @return {promise}
 */
module.exports = function (event, body, gh, st, stories) {
  const hook = (stories || events)[event];
  return hook(body, gh, st);
};

module.exports.events = events;
module.exports.hasHook = hasHook;
