'use strict';

const cfg = require('../config');
const debug = require('debug')('krush:issueComment');
const result = require('lodash').result;
const toLower = require('lodash').toLower;
const updateCodeReviewStatus = require('./shared').updateCodeReviewStatus;

/**
 * @param  {object} body
 * @param  {string} body.issue.number           Номер issue / pr
 * @param  {string} body.issue.user.login       Автор issue / pr
 * @param  {string} body.comment.body           Текст сообщения
 * @param  {string} body.comment.user.login     Автор сообщения (ревьювер)
 * @param  {string} body.repository.owner.login owner / org
 * @param  {string} body.repository.name        repo
 * @return {promise}
 */
function extractContext(body) {
  return {
    author: result(body, 'issue.user.login'),
    body: result(body, 'comment.body'),
    number: result(body, 'issue.number'),
    owner: toLower(result(body, 'repository.owner.login')),
    repo: toLower(result(body, 'repository.name')),
    reviewer: result(body, 'comment.user.login'),
    url: result(body, 'issue.html_url'),
  };
}

/**
 * @param  {object} body
 * @param  {string} body.issue.html_url         url
 * @param  {string} body.issue.number           Номер issue / pr
 * @param  {string} body.issue.user.login       Автор issue / pr
 * @param  {string} body.comment.body           Текст сообщения
 * @param  {string} body.comment.user.login     Автор сообщения (ревьювер)
 * @param  {string} body.repository.owner.login owner / org
 * @param  {string} body.repository.name        repo
 * @param  {github} gh
 * @return {promise}
 */
module.exports = function issueComment(body, gh) {
  const context = extractContext(body);

  debug(context);

  // Фильтруем служебные сообщения
  if (context.reviewer === cfg.servant) {
    return Promise.resolve(body);
  }

  return updateCodeReviewStatus(gh, context);
};

module.exports.extractContext = extractContext;
