// Проблема скопления одного человека в очереди
'use strict';

const {isEmpty, shuffle} = require('lodash');
const assert = require('assert');

module.exports = {
  pickFromQueue,
  pickQueue,
};

function pickFromQueue(queue, whiteList, exception) {
  // Если список из одного элемента, то это [exception], то выбирать некого
  if (whiteList.length < 2) {
    if (whiteList[0] !== exception) return whiteList[0];
    return null;
  }

  assert(typeof exception === 'string' && exception !== '' || typeof exception === 'number',
    `Expected "exception" to be not empty, instead got ${exception}`);

  if (queue.length === 0) shuffle(whiteList).forEach(member => queue.push(member));
  if (queue.length === 1 && queue[0] === exception) {
    const nextQueue = shuffle(whiteList).filter(member => member !== exception);
    const member = nextQueue.shift();
    nextQueue.forEach(member => queue.push(member));
    return member;
  }

  if (queue[0] === exception) swap(queue, 0, 1);

  return queue.shift();
}

function pickQueue(queues, key) {
  if (!Array.isArray(queues[key])) queues[key] = [];
  return queues[key];
}

function swap(collection, positionA, positionB) {
  const tmp = collection[positionA];
  collection[positionA] = collection[positionB];
  collection[positionB] = tmp;
}
