'use strict';

const {pickFromQueue, pickQueue} = require('./queue');

const queues = {};

function randomize(rndContext, collection, exception) {
  if (!Array.isArray(collection)) throw new TypeError('Collection should be an array');
  if (collection.length === 0) throw new Error('Collection should not be empty');

  const queue = pickQueue(queues, rndContext);
  const assignee = pickFromQueue(queue, collection, exception);
  return assignee;
}

/**
 * @param  {array}  collection
 * @param  {string} [context]
 * @param  {string} [exception]
 * @return {*}
 */
module.exports = randomize;
