'use strict';

const includes = require('lodash').includes;
const partial = require('lodash').partial;

const STATES = {
  PENDING: 'pending',
  SUCCESS: 'success',
  ERROR: 'error',
  FAILURE: 'failure',
};

/**
 * @param  {string} context
 * @param  {string} state         'pending|success|error|failure'
 * @param  {string} [description]
 * @return {object}
 */
function createStatus(context, state, description) {
  if (!includes(STATES, state)) {
    throw new Error(`Unknown state ${state}`);
  }

  return {
    state: state,
    context: context,
    description: description,
  };
}

const createCodeReviewStatus = partial(createStatus, 'Code review');

exports.STATES = STATES;
exports.createCodeReviewStatus = createCodeReviewStatus;
exports.createStatus = createStatus;
