export class HttpError extends Error {
    constructor(message: string, public readonly code = 500) {
        super(message);
        Object.setPrototypeOf(this, HttpError.prototype);
    }
}

export class HttpBadRequestError extends HttpError {
    constructor(message: string) {
        super(message, 400);
        Object.setPrototypeOf(this, HttpBadRequestError.prototype);
    }
}
